export interface Coupon {
  id?: number;
  code: string;
  description?: string;
  discount_type: 'percentage' | 'fixed';
  discount_value: number;
  max_discount?: number;
  min_purchase?: number;
  applicable_to: 'all' | 'specific';
  applicable_plan_ids?: number[];
  usage_limit?: number;
  used_count: number;
  valid_from?: string;
  valid_until?: string;
  is_active: boolean;
  created_at?: string;
  updated_at?: string;
}

export interface DiscountRule {
  id?: number;
  name: string;
  description?: string;
  rule_type: 'first_time' | 'bulk' | 'seasonal' | 'upgrade' | 'bundle';
  discount_type: 'percentage' | 'fixed';
  discount_value: number;
  conditions: Record<string, any>;
  applicable_plan_ids?: number[];
  priority: number;
  is_active: boolean;
  valid_from?: string;
  valid_until?: string;
  created_at?: string;
  updated_at?: string;
}

export interface ScholarshipProgram {
  id?: number;
  name: string;
  code: string;
  description?: string;
  eligibility_criteria: Record<string, any>;
  benefit_type: 'free' | 'percentage' | 'fixed';
  benefit_value: number;
  duration_months: number;
  max_beneficiaries?: number;
  current_beneficiaries: number;
  applicable_plan_ids?: number[];
  is_active: boolean;
  valid_from?: string;
  valid_until?: string;
  created_at?: string;
  updated_at?: string;
}

export interface ScholarshipApplication {
  id?: number;
  program_id: number;
  user_id: number;
  user_type: string;
  application_data: Record<string, any>;
  status: 'pending' | 'approved' | 'rejected' | 'expired';
  reviewed_by?: number;
  review_notes?: string;
  approved_at?: string;
  expires_at?: string;
  created_at?: string;
  updated_at?: string;
  program_name?: string;
  benefit_type?: string;
  benefit_value?: number;
}

export interface PriceCalculation {
  original_price: number;
  discount_amount: number;
  final_price: number;
  discount_source: 'coupon' | 'auto_discount' | 'scholarship' | 'none';
  discount_details?: Record<string, any>;
}
