export enum TransactionType {
  PROPERTY_PURCHASE = 'property_purchase',
  URGENT_SALE = 'urgent_sale',
  BOOKING = 'booking',
  TOKEN_AMOUNT = 'token_amount',
  REFUND = 'refund',
  VISIT_FEE = 'visit_fee',
  ESCROW_DEPOSIT = 'escrow_deposit'
}

export enum TransactionStatus {
  INITIATED = 'initiated',
  PROCESSING = 'processing',
  ESCROW_FUNDED = 'escrow_funded',
  COMPLETED = 'completed',
  FAILED = 'failed',
  REFUNDED = 'refunded',
  CANCELLED = 'cancelled'
}

export enum PaymentMethod {
  CREDIT_CARD = 'credit_card',
  DEBIT_CARD = 'debit_card',
  UPI = 'upi',
  NET_BANKING = 'net_banking',
  WALLET = 'wallet'
}

export interface Transaction {
  id: string;
  transaction_number: string;
  user_id: string;
  property_id?: number;
  transaction_type: TransactionType;
  transaction_status: TransactionStatus;
  payment_method: PaymentMethod;
  amount: number;
  currency: string;
  tax_amount: number;
  processing_fee: number;
  total_amount: number;
  mock_payment_id?: string;
  description?: string;
  initiated_at: string;
  completed_at?: string;
  failed_at?: string;
  created_at: string;
  updated_at: string;
  refund_status?: 'pending' | 'approved' | 'rejected' | 'completed';
  refund_number?: string;
}

export interface TransactionCreate {
  user_id: string;
  property_id?: number;
  transaction_type: TransactionType;
  payment_method: PaymentMethod;
  amount: number;
  currency?: string;
  description?: string;
  metadata?: Record<string, any>;
}

export interface TimelineEvent {
  id: string;
  transaction_id: string;
  event_type: string;
  event_status: 'success' | 'failed' | 'pending' | 'warning' | 'info';
  event_title: string;
  event_description?: string;
  event_data?: Record<string, any>;
  actor_id?: string;
  actor_type?: 'user' | 'system' | 'admin';
  event_timestamp: string;
  created_at: string;
}

export interface RefundCreate {
  transaction_id: string;
  refund_amount: number;
  refund_reason: string;
}

export interface Refund {
  id: string;
  transaction_id: string;
  refund_number: string;
  refund_amount: number;
  refund_reason: string;
  refund_status: 'pending' | 'approved' | 'rejected' | 'completed';
  requested_by: string;
  approved_by?: string;
  rejection_reason?: string;
  requested_at: string;
  approved_at?: string;
  rejected_at?: string;
  transaction_number?: string;
  user_id?: string;
  transaction_amount?: number;
}
