export interface ValuationRequest {
  propertyType: string;
  property_type?: string;
  location: string;
  area: number;
  bedrooms: number;
  floor_number?: string;
  total_floors?: string;
  property_age?: string;
  furnishing?: string;
  facing?: string;
  amenities?: string[];
}

export interface ValuationResult {
  estimatedValue: number;
  priceRange: {
    min: number;
    max: number;
  };
  confidence: number;
  comparables: Comparable[];
  marketTrends: {
    appreciation: number;
    demand: string;
  };
}

export interface PropertyData {
  type: string;
  location: string;
  area: number;
  bedrooms: number;
  amenities: string[];
  age?: string;
  furnishing?: string;
  facing?: string;
}

export interface Comparable {
  id: string;
  address: string;
  price: number;
  area: number;
  pricePerSqft: number;
  distance: number;
  similarity: number;
}