// Admin authentication utilities
export const loginAsAdmin = async () => {
  try {
    // Check if user is already logged in with valid token
    const token = localStorage.getItem('access_token');
    if (token && isAdmin()) {
      return true;
    }
    return false;
  } catch (error) {
    console.error('Admin login check failed:', error);
    return false;
  }
};

export const isAdmin = () => {
  const token = localStorage.getItem('access_token');
  if (!token) return false;
  
  try {
    const payload = JSON.parse(atob(token.split('.')[1]));
    return payload.is_admin === true;
  } catch {
    return false;
  }
};

export const getAdminToken = () => {
  const token = localStorage.getItem('access_token');
  if (token && isAdmin()) {
    return token;
  }
  return null;
};