// AI Description API utilities
//src/utils/aiDescriptionApi.ts

const API_BASE_URL = process.env.NODE_ENV === 'production' 
  ? 'https://your-production-api.com/api' 
  : 'http://localhost:8090/api';

export interface PropertyData {
  title: string;
  propertyType?: string;
  listingType?: string;
  bedrooms?: string;
  bathrooms?: string;
  builtUpArea?: string;
  city?: string;
  locality?: string;
  facing?: string;
  furnishing?: string;
  propertyAge?: string;
  amenities?: string[];
  features?: string[];
  highlights?: string[];
  salePrice?: string;
  monthlyRent?: string;
}

export interface AIDescriptionResponse {
  success: boolean;
  description?: string;
  error?: string;
}

export interface MultipleDescriptionsResponse {
  success: boolean;
  descriptions?: Array<{
    id: number;
    tone: string;
    description: string;
  }>;
  error?: string;
}

export const aiDescriptionApi = {
  /**
   * Generate a single AI description
   */
  async generateDescription(propertyData: any): Promise<AIDescriptionResponse> {
    try {
      const cleanData = {
        title: propertyData.title || 'Beautiful Property',
        propertyType: propertyData.propertyType || '',
        listingType: propertyData.listingType || '',
        bedrooms: propertyData.bedrooms || '',
        bathrooms: propertyData.bathrooms || '',
        builtUpArea: propertyData.builtUpArea || '',
        city: propertyData.city || '',
        locality: propertyData.locality || '',
        facing: propertyData.facing || '',
        furnishing: propertyData.furnishing || '',
        propertyAge: propertyData.propertyAge || '',
        amenities: propertyData.amenities || [],
        features: propertyData.features || [],
        highlights: propertyData.highlights || [],
        salePrice: propertyData.salePrice || '',
        monthlyRent: propertyData.monthlyRent || '',
        phone: propertyData.phone || '',
        email: propertyData.email || ''
      };

      const response = await fetch(`${API_BASE_URL}/ai-description/generate`, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify(cleanData)
      });

      const result = await response.json();
      return result;
    } catch (error) {
      console.error('Error generating AI description:', error);
      return {
        success: false,
        error: 'Failed to generate description'
      };
    }
  },

  /**
   * Generate multiple AI description variations
   */
  async generateMultipleDescriptions(propertyData: any): Promise<MultipleDescriptionsResponse> {
    try {
      const cleanData = {
        title: propertyData.title || 'Beautiful Property',
        propertyType: propertyData.propertyType || '',
        listingType: propertyData.listingType || '',
        bedrooms: propertyData.bedrooms || '',
        bathrooms: propertyData.bathrooms || '',
        builtUpArea: propertyData.builtUpArea || '',
        city: propertyData.city || '',
        locality: propertyData.locality || '',
        facing: propertyData.facing || '',
        furnishing: propertyData.furnishing || '',
        propertyAge: propertyData.propertyAge || '',
        amenities: propertyData.amenities || [],
        features: propertyData.features || [],
        highlights: propertyData.highlights || [],
        salePrice: propertyData.salePrice || '',
        monthlyRent: propertyData.monthlyRent || '',
        phone: propertyData.phone || '',
        email: propertyData.email || ''
      };

      const response = await fetch(`${API_BASE_URL}/ai-description/generate-multiple`, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify(cleanData)
      });

      const result = await response.json();
      return result;
    } catch (error) {
      console.error('Error generating multiple AI descriptions:', error);
      return {
        success: false,
        error: 'Failed to generate descriptions'
      };
    }
  },






};