export const initAuthAnimations = () => {
  const container = document.querySelector('.container');
  const loginLinks = document.querySelectorAll('.SignInLink');
  const registerLinks = document.querySelectorAll('.SignUpLink');

  registerLinks.forEach(link => {
    link.addEventListener('click', (e) => {
      e.preventDefault();
      container?.classList.add('active');
    });
  });

  loginLinks.forEach(link => {
    link.addEventListener('click', (e) => {
      e.preventDefault();
      container?.classList.remove('active');
    });
  });
};

export const toggleAuthMode = (isRegister: boolean) => {
  const container = document.querySelector('.container');
  if (isRegister) {
    container?.classList.add('active');
  } else {
    container?.classList.remove('active');
  }
};