// Authentication check utility
export const checkAuthAndRedirect = (): boolean => {
  const token = localStorage.getItem('access_token');
  
  if (!token) {
    console.warn('No access token found');
    window.location.href = '/login';
    return false;
  }
  
  try {
    // Check if token is expired
    const payload = JSON.parse(atob(token.split('.')[1]));
    const currentTime = Date.now() / 1000;
    
    if (payload.exp <= currentTime) {
      console.warn('Access token expired');
      localStorage.removeItem('access_token');
      localStorage.removeItem('refresh_token');
      window.location.href = '/login';
      return false;
    }
    
    return true;
  } catch (error) {
    console.error('Invalid token format:', error);
    localStorage.removeItem('access_token');
    localStorage.removeItem('refresh_token');
    window.location.href = '/login';
    return false;
  }
};

export const getAuthStatus = (): { isAuthenticated: boolean; needsRefresh: boolean } => {
  const token = localStorage.getItem('access_token');
  
  if (!token) {
    return { isAuthenticated: false, needsRefresh: false };
  }
  
  try {
    const payload = JSON.parse(atob(token.split('.')[1]));
    const currentTime = Date.now() / 1000;
    const fiveMinutes = 5 * 60; // 5 minutes in seconds
    
    if (payload.exp <= currentTime) {
      return { isAuthenticated: false, needsRefresh: false };
    }
    
    const needsRefresh = (payload.exp - currentTime) < fiveMinutes;
    return { isAuthenticated: true, needsRefresh };
  } catch (error) {
    return { isAuthenticated: false, needsRefresh: false };
  }
};