import { toast } from "sonner";

export const trackPropertyView = () => {
  const count = parseInt(localStorage.getItem('propertyViewCount') || '0');
  localStorage.setItem('propertyViewCount', (count + 1).toString());
  checkBadgeUnlock('view', count + 1);
};

export const trackPropertySave = () => {
  const saved = JSON.parse(localStorage.getItem('savedProperties') || '[]');
  checkBadgeUnlock('save', saved.length);
};

export const trackSearch = () => {
  const history = JSON.parse(localStorage.getItem('searchHistory') || '[]');
  checkBadgeUnlock('search', history.length);
};

export const trackVisitSchedule = () => {
  const visits = JSON.parse(localStorage.getItem('scheduledVisits') || '[]');
  checkBadgeUnlock('visit', visits.length);
};

export const trackInquiry = () => {
  const inquiries = JSON.parse(localStorage.getItem('inquiries') || '[]');
  checkBadgeUnlock('inquiry', inquiries.length);
};

const checkBadgeUnlock = (type: string, count: number) => {
  const unlockedBadges = JSON.parse(localStorage.getItem('unlockedBadges') || '[]');
  
  const milestones: Record<string, Array<{count: number, name: string, points: number}>> = {
    view: [
      { count: 1, name: 'First Steps', points: 10 },
      { count: 20, name: 'Active Viewer', points: 50 },
      { count: 50, name: 'Property Expert', points: 150 },
      { count: 100, name: 'Power User', points: 250 }
    ],
    save: [
      { count: 1, name: 'Collector', points: 15 },
      { count: 30, name: 'Master Collector', points: 300 }
    ],
    search: [
      { count: 5, name: 'Explorer', points: 20 },
      { count: 25, name: 'Market Analyst', points: 150 }
    ],
    visit: [
      { count: 3, name: 'Visit Scheduler', points: 75 },
      { count: 10, name: 'VIP Buyer', points: 300 }
    ],
    inquiry: [
      { count: 5, name: 'Serious Buyer', points: 100 }
    ]
  };

  const typeMilestones = milestones[type] || [];
  const milestone = typeMilestones.find(m => m.count === count);
  
  if (milestone && !unlockedBadges.includes(milestone.name)) {
    unlockedBadges.push(milestone.name);
    localStorage.setItem('unlockedBadges', JSON.stringify(unlockedBadges));
    
    toast.success(`🎉 Badge Unlocked: ${milestone.name}!`, {
      description: `You earned ${milestone.points} points!`,
      duration: 5000,
    });
  }
};