// Standardized status values across frontend and backend
export const VERIFICATION_STATUS = {
  COMPLETED: 'completed',
  PENDING: 'pending', 
  FAILED: 'failed',
  PROCESSING: 'processing'
} as const;

export type VerificationStatus = typeof VERIFICATION_STATUS[keyof typeof VERIFICATION_STATUS];

// Judicial status values
export const JUDICIAL_STATUS = {
  CLEAR: 'clear',
  PENDING: 'pending',
  DISPUTED: 'disputed', 
  MORTGAGED: 'mortgaged'
} as const;

export type JudicialStatus = typeof JUDICIAL_STATUS[keyof typeof JUDICIAL_STATUS];

// Document types
export const DOC_TYPES = {
  TITLE_DEED: 'titleDeed',
  SALE_DEED: 'saleDeed', 
  ENCUMBRANCE: 'encumbrance',
  TAX_RECEIPTS: 'taxReceipts',
  KHATA_PATTA: 'khataPatta',
  NOC: 'noc',
  OCCUPANCY: 'occupancy',
  BUILDER_DOCS: 'builderDocs',
  ID_PROOF: 'idProof',
  OWNER_ADDRESS_PROOF: 'ownerAddressProof'
} as const;

export type DocType = typeof DOC_TYPES[keyof typeof DOC_TYPES];

// Validation patterns
export const VALIDATION_PATTERNS = {
  AADHAR: /^\d{12}$/,
  PAN: /^[A-Z]{5}\d{4}[A-Z]$/,
  PHONE: /^\d{10}$/,
  PINCODE: /^\d{6}$/
} as const;

// File validation
export const FILE_VALIDATION = {
  ALLOWED_TYPES: ['application/pdf', 'image/jpeg', 'image/png'],
  MAX_SIZE: 10 * 1024 * 1024, // 10MB
  MIN_SIZE: 1024 // 1KB
} as const;