// Test utility to debug user authentication issues
import { getUserId, validateUserAuthentication } from '../utils/userUtils';

export const debugUserAuthentication = () => {
  console.log('🔧 === USER AUTHENTICATION DEBUG ===');
  
  // Check all possible user storage locations
  const userStr = localStorage.getItem('user');
  const agentId = localStorage.getItem('agentId');
  const sellerId = localStorage.getItem('sellerId');
  const accessToken = localStorage.getItem('access_token');
  const agentToken = localStorage.getItem('agentToken');
  const sellerToken = localStorage.getItem('sellerToken');
  
  console.log('📦 Storage Contents:');
  console.log('  user:', userStr);
  console.log('  agentId:', agentId);
  console.log('  sellerId:', sellerId);
  console.log('  access_token:', accessToken ? 'Present' : 'Missing');
  console.log('  agentToken:', agentToken ? 'Present' : 'Missing');
  console.log('  sellerToken:', sellerToken ? 'Present' : 'Missing');
  
  // Test user ID extraction
  try {
    const userId = getUserId();
    console.log('✅ getUserId() result:', userId);
    
    if (userId) {
      console.log('✅ User ID extraction successful');
      
      // Test validation
      try {
        const validatedUserId = validateUserAuthentication();
        console.log('✅ User validation successful:', validatedUserId);
      } catch (error) {
        console.error('❌ User validation failed:', error);
      }
    } else {
      console.warn('⚠️ No user ID found - user may not be logged in');
    }
  } catch (error) {
    console.error('❌ getUserId() failed:', error);
  }
  
  // Parse and analyze user object if present
  if (userStr && userStr !== '{}') {
    try {
      const user = JSON.parse(userStr);
      console.log('👤 Parsed User Object:');
      console.log('  Keys:', Object.keys(user));
      console.log('  id:', user.id);
      console.log('  user_id:', user.user_id);
      console.log('  uuid:', user.uuid);
      console.log('  userId:', user.userId);
      console.log('  email:', user.email);
      console.log('  role:', user.role);
    } catch (error) {
      console.error('❌ Failed to parse user object:', error);
    }
  }
  
  console.log('🔧 === DEBUG COMPLETE ===');
};

// Make it globally available for browser console testing
if (typeof window !== 'undefined') {
  (window as any).debugUserAuth = debugUserAuthentication;
}