// Debug helper utilities
export const debugLog = (message: string, data?: any) => {
  if (process.env.NODE_ENV === 'development') {
    console.log(`[DEBUG] ${message}`, data);
  }
};

export const debugError = (message: string, error?: any) => {
  if (process.env.NODE_ENV === 'development') {
    console.error(`[ERROR] ${message}`, error);
  }
};

export const setupErrorHandling = () => {
  if (process.env.NODE_ENV === 'development') {
    window.addEventListener('error', (event) => {
      console.error('[GLOBAL ERROR]', event.error);
    });
    
    window.addEventListener('unhandledrejection', (event) => {
      console.error('[UNHANDLED PROMISE]', event.reason);
    });
  }
};