// Kannada to English translation dictionary
export const kannadaToEnglish: Record<string, string> = {
  // Greetings
  'ನಮಸ್ಕಾರ': 'hello',
  'ಧನ್ಯವಾದ': 'thank you',
  'ಹೌದು': 'yes',
  'ಇಲ್ಲ': 'no',
  'ಸರಿ': 'okay',
  
  // Question words
  'ಏನು': 'what',
  'ಎಲ್ಲಿ': 'where',
  'ಎಷ್ಟು': 'how much',
  'ಯಾವುದು': 'which',
  'ಹೇಗೆ': 'how',
  'ಯಾವಾಗ': 'when',
  'ಯಾರು': 'who',
  'ಏಕೆ': 'why',
  
  // Property terms
  'ಆಸ್ತಿ': 'property',
  'ಮನೆ': 'house',
  'ಫ್ಲಾಟ್': 'flat',
  'ಅಪಾರ್ಟ್ಮೆಂಟ್': 'apartment',
  'ಬೆಲೆ': 'price',
  'ಗಾತ್ರ': 'size',
  'ಸ್ಥಳ': 'location',
  'ಪ್ರದೇಶ': 'area',
  'ದೊಡ್ಡ': 'big',
  'ಚಿಕ್ಕ': 'small',
  'ವಿಸ್ತೀರ್ಣ': 'area',
  
  // Rooms
  'ಮಲಗುವ': 'bedroom',
  'ಕೋಣೆ': 'room',
  'ಕೋಣೆಗಳು': 'rooms',
  'ಸ್ನಾನಗೃಹ': 'bathroom',
  'ಅಡುಗೆ': 'kitchen',
  'ಹಾಲ್': 'hall',
  'ಬಾಲ್ಕನಿ': 'balcony',
  'ಮಹಡಿ': 'floor',
  'ಛಾವಣಿ': 'terrace',
  
  // Amenities
  'ಪಾರ್ಕಿಂಗ್': 'parking',
  'ಜಿಮ್': 'gym',
  'ಈಜುಕೊಳ': 'pool',
  'ಲಿಫ್ಟ್': 'lift',
  'ಭದ್ರತೆ': 'security',
  'ಉದ್ಯಾನ': 'garden',
  'ಕ್ಲಬ್': 'club',
  'ಆಟದ': 'playground',
  'ಮೈದಾನ': 'ground',
  'ವಾಹನ': 'vehicle',
  'ನಿಲುಗಡೆ': 'parking',
  'ವಿದ್ಯುತ್': 'electricity',
  'ನೀರು': 'water',
  'ಸಿಸಿಟಿವಿ': 'cctv',
  'ಸೌಲಭ್ಯಗಳು': 'amenities',
  'ಸೌಲಭ್ಯ': 'amenity',
  
  // Actions
  'ನೋಡಲು': 'see',
  'ನೋಡು': 'see',
  'ಭೇಟಿ': 'visit',
  'ಖರೀದಿಸು': 'buy',
  'ಮಾರಾಟ': 'sell',
  'ಬಾಡಿಗೆ': 'rent',
  'ಮಾತುಕತೆ': 'negotiate',
  'ತೋರಿಸು': 'show',
  'ಬುಕ್': 'book',
  
  // Descriptors
  'ಹೊಸ': 'new',
  'ಹಳೆಯ': 'old',
  'ಒಳ್ಳೆಯ': 'good',
  'ಕೆಟ್ಟ': 'bad',
  'ದುಬಾರಿ': 'expensive',
  'ಅಗ್ಗ': 'cheap',
  'ಸುಂದರ': 'beautiful',
  'ಸ್ವಚ್ಛ': 'clean',
  'ದೊಡ್ಡದು': 'large',
  
  // Common phrases
  'ಇದೆಯೇ': 'is there',
  'ಇದೆ': 'there is',
  'ಬೇಕು': 'want',
  'ಬಯಸುತ್ತೇನೆ': 'want',
  'ತಿಳಿಯಲು': 'know',
  'ಹೇಳಿ': 'tell',
  'ಕೊಡಿ': 'give'
};

// English to Kannada for common terms
export const englishToKannada: Record<string, string> = {
  'bedroom': 'ಮಲಗುವ ಕೋಣೆ',
  'bedrooms': 'ಮಲಗುವ ಕೋಣೆಗಳು',
  'bathroom': 'ಸ್ನಾನಗೃಹ',
  'bathrooms': 'ಸ್ನಾನಗೃಹಗಳು',
  'parking': 'ಪಾರ್ಕಿಂಗ್',
  'gym': 'ಜಿಮ್',
  'pool': 'ಈಜುಕೊಳ',
  'swimming pool': 'ಈಜುಕೊಳ',
  'lift': 'ಲಿಫ್ಟ್',
  'elevator': 'ಲಿಫ್ಟ್',
  'security': 'ಭದ್ರತೆ',
  'garden': 'ಉದ್ಯಾನ',
  'club': 'ಕ್ಲಬ್',
  'club house': 'ಕ್ಲಬ್ ಹೌಸ್',
  'playground': 'ಆಟದ ಮೈದಾನ',
  'years': 'ವರ್ಷಗಳು',
  'year': 'ವರ್ಷ',
  'square feet': 'ಚದರ ಅಡಿ',
  'sqft': 'ಚದರ ಅಡಿ'
};
