// Utility function for agent/seller contact actions
export const contactLead = async (leadId: string, contactMethod: 'call' | 'whatsapp' | 'email', userId: string) => {
  try {
    const API_BASE = import.meta.env.VITE_API_BASE || "http://localhost:8090/api";
    const token = localStorage.getItem("access_token");

    const response = await fetch(
      `${API_BASE}/leads-management/leads/${leadId}/contact?user_id=${userId}&contact_method=${contactMethod}`,
      {
        method: "PUT",
        headers: {
          "Content-Type": "application/json",
          ...(token && { Authorization: `Bearer ${token}` }),
        },
      }
    );

    if (response.ok) {
      const result = await response.json();
      console.log(`Lead ${leadId} marked as contacted via ${contactMethod}`);
      return result;
    } else {
      console.error(`Failed to mark lead ${leadId} as contacted`);
      return null;
    }
  } catch (error) {
    console.error(`Error contacting lead ${leadId}:`, error);
    return null;
  }
};

// Function to handle WhatsApp contact
export const handleLeadWhatsApp = async (phone: string, leadId: string, userId: string) => {
  if (phone && leadId) {
    // Clean phone number
    const cleanPhone = phone.replace(/[^+\d]/g, "");
    // Open WhatsApp
    window.open(`https://wa.me/${cleanPhone}`, "_blank");
    // Mark lead as contacted
    await contactLead(leadId, 'whatsapp', userId);
  }
};

// Function to handle Call contact
export const handleLeadCall = async (phone: string, leadId: string, userId: string) => {
  if (phone && leadId) {
    // Open phone dialer
    window.open(`tel:${phone}`, "_self");
    // Mark lead as contacted
    await contactLead(leadId, 'call', userId);
  }
};