interface Notification {
  id: string;
  title: string;
  message: string;
  type: 'info' | 'success' | 'warning' | 'error';
  isRead: boolean;
  createdAt: string;
}

// Mock notifications for development
const mockNotifications: Notification[] = [
  {
    id: '1',
    title: 'Property Verification Complete',
    message: 'Your property documents have been verified successfully.',
    type: 'success',
    isRead: false,
    createdAt: new Date().toISOString()
  },
  {
    id: '2', 
    title: 'New Inquiry Received',
    message: 'You have received a new inquiry for your property listing.',
    type: 'info',
    isRead: false,
    createdAt: new Date(Date.now() - 3600000).toISOString()
  }
];

export const getUserNotifications = async (): Promise<Notification[]> => {
  try {
    const response = await fetch('/api/notifications/', {
      method: 'GET',
      headers: {
        'Accept': 'application/json',
        'Authorization': `Bearer ${localStorage.getItem('access_token')}`
      }
    });

    if (response.ok) {
      const data = await response.json();
      return data.notifications || mockNotifications;
    }
    
    return mockNotifications;
  } catch (error) {
    return mockNotifications;
  }
};

export const markNotificationAsRead = async (notificationId: string): Promise<boolean> => {
  try {
    const response = await fetch(`/api/notifications/${notificationId}/read`, {
      method: 'PUT',
      headers: {
        'Accept': 'application/json',
        'Authorization': `Bearer ${localStorage.getItem('access_token')}`
      }
    });
    return response.ok;
  } catch (error) {
    return false;
  }
};