// Minimal real estate knowledge base
export const realEstateKnowledge = {
  localities: {
    bangalore: ['Whitefield', 'Koramangala', 'Indiranagar'],
    mumbai: ['Bandra', 'Andheri', 'Powai'],
    delhi: ['Gurgaon', 'Noida', 'Dwarka']
  },
  
  amenityTypes: [
    'school', 'hospital', 'shopping_mall', 'restaurant', 
    'park', 'bank', 'subway_station'
  ],

  getLocalityContext: (locality: string) => {
    return `Real estate market analysis for ${locality}`;
  }
};

export const validateLocalityData = (data: any) => {
  return data && data.name;
};

export const getApproximateCoordinates = (locality: string) => {
  return { lat: 12.9716, lng: 77.5946 };
};