// Sample property images for fallback
const sampleImages = [
  '/images/property1.jpg',
  '/images/property2.jpg',
  '/images/property3.jpg',
  '/images/property4.jpg',
  '/images/property5.jpg'
];

export const getRandomPropertyImages = (count: number = 1): string[] => {
  const shuffled = [...sampleImages].sort(() => 0.5 - Math.random());
  return shuffled.slice(0, count);
};

export const getPropertyImageByType = (type: string): string => {
  const typeMap: Record<string, string> = {
    apartment: '/images/apartment.jpg',
    villa: '/images/villa.jpg',
    house: '/images/house.jpg',
    plot: '/images/plot.jpg',
    commercial: '/images/commercial.jpg'
  };
  return typeMap[type] || sampleImages[0];
};

export default getRandomPropertyImages;