/**
 * Utility functions for managing user-specific localStorage
 */

export const getUserSpecificKey = (baseKey: string): string => {
  const sellerId = localStorage.getItem('sellerId');
  return sellerId ? `${baseKey}_${sellerId}` : baseKey;
};

export const setUserData = (key: string, data: any): void => {
  const userKey = getUserSpecificKey(key);
  localStorage.setItem(userKey, JSON.stringify(data));
};

export const getUserData = (key: string, defaultValue: any = null): any => {
  const userKey = getUserSpecificKey(key);
  const stored = localStorage.getItem(userKey);
  return stored ? JSON.parse(stored) : defaultValue;
};

export const removeUserData = (key: string): void => {
  const userKey = getUserSpecificKey(key);
  localStorage.removeItem(userKey);
};

export const clearUserData = (): void => {
  const sellerId = localStorage.getItem('sellerId');
  if (sellerId) {
    // Clear all user-specific data
    const keysToRemove: string[] = [];
    for (let i = 0; i < localStorage.length; i++) {
      const key = localStorage.key(i);
      if (key && key.endsWith(`_${sellerId}`)) {
        keysToRemove.push(key);
      }
    }
    keysToRemove.forEach(key => localStorage.removeItem(key));
  }
};