/**
 * Utility for tenant-aware navigation
 * Automatically preserves tenant parameter across all navigation
 */

export const getTenantAwareHref = (path: string): string => {
  const params = new URLSearchParams(window.location.search);
  const tenant = params.get('tenant');
  
  if (tenant) {
    const separator = path.includes('?') ? '&' : '?';
    return `${path}${separator}tenant=${tenant}`;
  }
  
  return path;
};

export const getCurrentTenant = (): string | null => {
  const params = new URLSearchParams(window.location.search);
  return params.get('tenant');
};

export const navigateWithTenant = (navigate: any, path: string) => {
  const tenantAwarePath = getTenantAwareHref(path);
  navigate(tenantAwarePath);
};
