import { toast } from 'sonner';

export const safeToast = {
  success: (message: string) => {
    try {
      toast.success(message);
    } catch (error) {
      console.log('Success:', message);
    }
  },
  error: (message: string) => {
    try {
      toast.error(message);
    } catch (error) {
      console.error('Error:', message);
    }
  },
  info: (message: string) => {
    try {
      toast.info(message);
    } catch (error) {
      console.log('Info:', message);
    }
  },
  warning: (message: string) => {
    try {
      toast.warning(message);
    } catch (error) {
      console.warn('Warning:', message);
    }
  }
};