export const validation = {
  required: (message: string) => ({
    required: message
  }),

  minLength: (min: number, message: string) => ({
    minLength: { value: min, message }
  }),

  maxLength: (max: number, message: string) => ({
    maxLength: { value: max, message }
  }),

  pattern: (pattern: RegExp, message: string) => ({
    pattern: { value: pattern, message }
  }),

  min: (min: number, message: string) => ({
    min: { value: min, message }
  }),

  fileSize: (maxSize: number) => (files: FileList) => {
    if (!files) return true;
    for (let i = 0; i < files.length; i++) {
      if (files[i].size > maxSize) {
        return `File size must be less than ${maxSize / 1024 / 1024}MB`;
      }
    }
    return true;
  },

  fileType: (allowedTypes: string[]) => (files: FileList) => {
    if (!files) return true;
    for (let i = 0; i < files.length; i++) {
      const fileType = files[i].type.split('/')[1];
      if (!allowedTypes.includes(fileType)) {
        return `Only ${allowedTypes.join(', ')} files are allowed`;
      }
    }
    return true;
  }
};