export interface ScheduledVisit {
  id: string;
  propertyId: string;
  propertyName: string;
  propertyAddress: string;
  scheduledDate: string;
  scheduledTime: string;
  status: "scheduled" | "completed" | "cancelled";
  geofence: {
    lat: number;
    lng: number;
    radius: number;
  };
  qrCode: string;
}

export interface VisitBadge {
  id: string;
  visitId: string;
  propertyName: string;
  propertyAddress: string;
  badgeType: string;
  badgeLevel: string;
  verificationMethod: string[];
  timestamp: string;
  locationAccuracy: number;
  earnedPoints: number;
  gpsCoords: { lat: number; lng: number };
}

export const getScheduledVisits = (): ScheduledVisit[] => {
  const visits = localStorage.getItem("scheduledVisits");
  return visits ? JSON.parse(visits) : [];
};

export const saveScheduledVisit = (visit: ScheduledVisit): void => {
  const visits = getScheduledVisits();
  visits.push(visit);
  localStorage.setItem("scheduledVisits", JSON.stringify(visits));
};

export const updateVisitStatus = (visitId: string, status: ScheduledVisit["status"]): void => {
  const visits = getScheduledVisits();
  const updated = visits.map((v) => (v.id === visitId ? { ...v, status } : v));
  localStorage.setItem("scheduledVisits", JSON.stringify(updated));
};

export const getVisitBadges = (): VisitBadge[] => {
  const badges = localStorage.getItem("visitBadges");
  return badges ? JSON.parse(badges) : [];
};

export const saveVisitBadge = (badge: VisitBadge): void => {
  const badges = getVisitBadges();
  badges.push(badge);
  localStorage.setItem("visitBadges", JSON.stringify(badges));
};

export const generateQRCode = (visitId: string): string => {
  return `VISIT-${visitId}-${Date.now()}`;
};
