// Wishlist API functions - using correct backend endpoints
const API_BASE = 'http://localhost:8090/api';

export interface WishlistItem {
  id: string;
  property_id: string;
  user_id: string;
  created_at: string;
}

// Add property to wishlist
export const addToWishlist = async (propertyId: string): Promise<WishlistItem> => {
  const token = localStorage.getItem('access_token');
  const response = await fetch(`${API_BASE}/user-dashboard/wishlist/${propertyId}`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      ...(token && { 'Authorization': `Bearer ${token}` }),
    },
  });
  
  if (!response.ok) {
    throw new Error('Failed to add to wishlist');
  }
  
  return response.json();
};

// Remove property from wishlist
export const removeFromWishlist = async (propertyId: string): Promise<void> => {
  const token = localStorage.getItem('access_token');
  const response = await fetch(`${API_BASE}/user-dashboard/wishlist/${propertyId}`, {
    method: 'DELETE',
    headers: {
      ...(token && { 'Authorization': `Bearer ${token}` }),
    },
  });
  
  if (!response.ok) {
    throw new Error('Failed to remove from wishlist');
  }
};

// Get user's wishlist
export const getWishlist = async (): Promise<WishlistItem[]> => {
  const token = localStorage.getItem('access_token');
  const response = await fetch(`${API_BASE}/user-dashboard/wishlist/`, {
    headers: {
      ...(token && { 'Authorization': `Bearer ${token}` }),
    },
  });
  
  if (!response.ok) {
    throw new Error('Failed to fetch wishlist');
  }
  
  return response.json();
};

// Check if property is in wishlist
export const isInWishlist = async (propertyId: string): Promise<boolean> => {
  try {
    const token = localStorage.getItem('access_token');
    const response = await fetch(`${API_BASE}/user-dashboard/wishlist/${propertyId}`, {
      method: 'GET',
      headers: {
        ...(token && { 'Authorization': `Bearer ${token}` }),
      },
    });
    
    if (!response.ok) {
      return false;
    }
    
    const data = await response.json();
    return data.is_saved || false;
  } catch {
    return false;
  }
};